﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;
using VIRP_WEB.BaseCode;
using VIRP_WEB.Controls.Custom.EFR;
using VIRP.EFR.DAL;
using VIRP.CRS.BO;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Custom.EFR
{
    public partial class DoDFragment : EfrBasePage
    {
        protected readonly string PatientWorkflowsPage = "~/Custom/EFR/Patients/PatientWorkflows.aspx?patientId=";
        private string pFullName = "";

        protected override void Page_Load(object sender, EventArgs e)
        {
            LoadBaseControls();

            if (!IsPostBack)
            {
                string patientId = string.Empty;

                HiddenFieldPatientID.Value = GetQueryStringValue(); // Request["patientId"].ToString();
                LinkButtonAddLab.PostBackUrl = string.Format("~/Custom/EFR/DoDFragment/DoDFragmentLab.aspx?patientId={0}",
                                                              HiddenFieldPatientID.Value);
                DisplayPatientInfo();

                ReplacePageTitle("Patients > Patient Lookup > Workflows > DoD Fragment Data > " + pFullName);
            }
        }

        private string GetQueryStringValue()
        {
            string patientId = string.Empty;
            try
            {
                if (IsQueryStringValid())
                {
                    patientId = Request.QueryString["patientId"].ToString();
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Error parsing request data: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }
            return patientId;
        }

        private bool IsQueryStringValid()
        {
            bool isQuesryStringValid = false;
            if (Request.QueryString["patientId"] != null)
            {
                if (Regex.IsMatch(Request.QueryString["patientId"].ToString(), "^[a-zA-Z0-9]*$"))
                {
                    isQuesryStringValid = true;
                }
            }
            return isQuesryStringValid;
        }

        private void DisplayPatientInfo()
        {
            if (!string.IsNullOrEmpty(BaseCode.Helpers.AntiXssEval(Request.QueryString["patientId"])))
            {
                int patientId = Convert.ToInt32(BaseCode.Helpers.AntiXssEval(Request.QueryString["patientId"]));

                VIRP.CRS.BO.PATIENT p = VIRP.CRS.BLL.PATIENTManager.GetItem(CurrentUser, CurrentRegistryId, patientId);
                VIRP.CRS.BO.PATIENT_REG pr = VIRP.CRS.BLL.PATIENT_REGManager.GetItem(CurrentUser, CurrentRegistryId, patientId);

                if (p != null)
                {
                    BaseControlLabelPatientFullName.Text = pFullName = p.FULL_NAME;
                }
                if (pr != null)
                { 
                    BaseControlLabelPatientSnum.Text = pr.Snum;
                }                
            }
        }

        private void LoadBaseControls()
        {
            CommonManager commonManager = new CommonManager();
            List<STD_GUI_CONTROL> controls = commonManager.GetStdGuiControlsByCategory("DOD_FRAGMENT", UserSession.CurrentRegistryId);

            foreach (STD_GUI_CONTROL dbItem in controls)
            {
                Control userControl = null;

                userControl = PanelPatient.FindControl(dbItem.USER_CONTROL_ID);
                if (userControl != null)
                {
                    BaseControlLabel baseControl = (BaseControlLabel)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL);
                }
            }
        }
        
        protected void ButtonBack_Click(object sender, EventArgs e)
        {
            //Response.Redirect(String.Format("PatientWorkflows.aspx?patientId={0}", HiddenFieldPatientID.Value));

            try
            {
                string patientID = string.Empty;
                if (HiddenFieldPatientID != null)
                {
                    //TODO: What to do with this - seems like the wrong encoding
                    patientID = AntiXssEncoder.UrlEncode(HiddenFieldPatientID.Value);
                }

                string destinationUrl = string.Concat(PatientWorkflowsPage, patientID);
                string currentHost = Request.Url.Host;
                if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
                {
                    //Response.Redirect(destinationUrl);
                    Server.Transfer(destinationUrl);
                    //Response.Redirect(destinationUrl);
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Failure in to redirect to Export page: - patient workflow page.: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }
        }
    }
}